/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SkyclawThrashEffect
extends OneShotEffect {
    SkyclawThrashEffect() {
        super(Outcome.Benefit);
        this.staticText = "flip a coin. If you win the flip, {this} gets +1/+1 and gains flying until end of turn";
    }

    private SkyclawThrashEffect(SkyclawThrashEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkyclawThrashEffect copy() {
        return new SkyclawThrashEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent sourcePermanent = game.getPermanent(source.getSourceId());
            if (controller.flipCoin(source, game, true) && sourcePermanent != null) {
                BoostTargetEffect effect = new BoostTargetEffect(1, 1, Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(sourcePermanent, game));
                game.addEffect((ContinuousEffect)effect, source);
                effect = new GainAbilityTargetEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(sourcePermanent, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

