/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.game.Game;
import mage.players.Player;

class SkyserpentSeekerEffect
extends OneShotEffect {
    SkyserpentSeekerEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "Reveal cards from the top of your library until you reveal two land cards. Put those land cards onto the battlefield tapped and the rest on the bottom of your library in a random order";
    }

    private SkyserpentSeekerEffect(SkyserpentSeekerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkyserpentSeekerEffect copy() {
        return new SkyserpentSeekerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl revealedCards = new CardsImpl();
        CardsImpl lands = new CardsImpl();
        for (Card card : controller.getLibrary().getCards(game)) {
            if (card.isLand()) {
                lands.add(card);
                if (lands.size() != 2) continue;
                break;
            }
            revealedCards.add(card);
        }
        controller.revealCards(source, (Cards)revealedCards, game);
        PutCards.BATTLEFIELD_TAPPED.moveCards(controller, (Cards)lands, source, game);
        PutCards.BOTTOM_RANDOM.moveCards(controller, (Cards)revealedCards, source, game);
        return true;
    }
}

