/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;

class SkyshroudWarBeastEffect
extends ContinuousEffectImpl {
    SkyshroudWarBeastEffect() {
        super(Duration.EndOfGame, Layer.PTChangingEffects_7, SubLayer.CharacteristicDefining_7a, Outcome.BoostCreature);
        this.staticText = "{this}'s power and toughness are each equal to the number of nonbasic lands the chosen player controls";
    }

    private SkyshroudWarBeastEffect(SkyshroudWarBeastEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SkyshroudWarBeastEffect copy() {
        return new SkyshroudWarBeastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject target = game.getObject(source);
        if (controller == null || target == null) {
            return false;
        }
        UUID playerId = (UUID)game.getState().getValue(source.getSourceId().toString() + "_opponent");
        FilterLandPermanent filter = FilterLandPermanent.nonbasicLand();
        filter.add((Predicate)new ControllerIdPredicate(playerId));
        int number = new PermanentsOnBattlefieldCount((FilterPermanent)filter).calculate(game, source, (Effect)this);
        target.getPower().setModifiedBaseValue(number);
        target.getToughness().setModifiedBaseValue(number);
        return true;
    }
}

