/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SlaveringNullsTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterControlledLandPermanent filter = new FilterControlledLandPermanent();

    public SlaveringNullsTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DiscardTargetEffect(1), true);
    }

    private SlaveringNullsTriggeredAbility(SlaveringNullsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SlaveringNullsTriggeredAbility copy() {
        return new SlaveringNullsTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getSourceId().equals(this.sourceId) && ((DamagedPlayerEvent)event).isCombatDamage() && game.getBattlefield().countAll((FilterPermanent)filter, this.controllerId, game) > 0) {
            Permanent slaveringNulls = game.getPermanent(event.getSourceId());
            Player player = game.getPlayer(event.getTargetId());
            if (slaveringNulls != null && player != null) {
                Effect effect = (Effect)this.getEffects().get(0);
                effect.setTargetPointer((TargetPointer)new FixedTarget(player.getId()));
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} deals combat damage to a player, if you control a Swamp, you may have that player discard a card.";
    }

    static {
        filter.add((Predicate)SubType.SWAMP.getPredicate());
    }
}

