/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.CounterAnyPredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class SlipperyBogbonderEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("creatures to move counters from");

    SlipperyBogbonderEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then move any number of counters from among creatures you control onto that creature.";
    }

    private SlipperyBogbonderEffect(SlipperyBogbonderEffect effect) {
        super((OneShotEffect)effect);
    }

    public SlipperyBogbonderEffect copy() {
        return new SlipperyBogbonderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent creature = game.getPermanent(source.getFirstTarget());
        FilterPermanent filterPermanent = filter.copy();
        filterPermanent.add(Predicates.not((Predicate)new PermanentIdPredicate(source.getFirstTarget())));
        if (player == null || creature == null || game.getBattlefield().count(filterPermanent, source.getControllerId(), source, game) < 1) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filterPermanent, true);
        player.choose(this.outcome, (Target)target, source, game);
        List permanents = target.getTargets().stream().filter(uuid -> !creature.getId().equals(uuid)).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            return false;
        }
        HashMap counterMap = new HashMap();
        for (Permanent permanent : permanents) {
            permanent.getCounters(game).entrySet().stream().forEach(entry -> {
                int num = player.getAmount(0, ((Counter)entry.getValue()).getCount(), "Choose how many " + (String)entry.getKey() + " counters to remove from " + permanent.getLogName(), source, game);
                counterMap.computeIfAbsent(permanent.getId(), x -> new HashMap()).put(entry.getKey(), num);
            });
        }
        for (Permanent permanent : permanents) {
            ((Map)counterMap.get(permanent.getId())).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).map(entry -> CounterType.findByName((String)((String)entry.getKey())).createInstance(((Integer)entry.getValue()).intValue())).filter(counter -> creature.addCounters(counter, source.getControllerId(), source, game)).forEach(counter -> permanent.removeCounters(counter, source, game));
        }
        return true;
    }

    static {
        filter.add((Predicate)CounterAnyPredicate.instance);
    }
}

