/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import mage.MageObject;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.builder.ConditionalManaBuilder;
import mage.cards.s.SlobadIronGoblinManaBuilder;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class SlobadIronGoblinManaEffect
extends ManaEffect {
    private final ConditionalManaBuilder manaBuilder = new SlobadIronGoblinManaBuilder();

    SlobadIronGoblinManaEffect() {
        this.staticText = "Add an amount of {R} equal to the sacrificed artifact's mana value. Spend this mana only to cast artifact spells or activate abilities of artifacts";
    }

    private SlobadIronGoblinManaEffect(SlobadIronGoblinManaEffect effect) {
        super((ManaEffect)effect);
    }

    public SlobadIronGoblinManaEffect copy() {
        return new SlobadIronGoblinManaEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        if (game == null) {
            return new ArrayList<Mana>();
        }
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        int cmc = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACT, source.getControllerId(), source, game).stream().mapToInt(MageObject::getManaValue).max().orElse(-1);
        if (cmc > 0) {
            netMana.add((Mana)this.manaBuilder.setMana(Mana.RedMana((int)cmc), source, game).build(new Object[0]));
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        if (game == null) {
            return new Mana();
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return new Mana();
        }
        int value = CardUtil.castStream((Stream)source.getCosts().stream(), SacrificeTargetCost.class).map(SacrificeTargetCost::getPermanents).flatMap(Collection::stream).mapToInt(MageObject::getManaValue).sum();
        return (Mana)this.manaBuilder.setMana(Mana.RedMana((int)value), source, game).build(new Object[0]);
    }
}

