/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SludgeStriderEffect
extends OneShotEffect {
    SludgeStriderEffect() {
        super(Outcome.Detriment);
        this.staticText = "target player loses 1 life and you gain 1 life";
    }

    private SludgeStriderEffect(SludgeStriderEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        Player you = game.getPlayer(source.getControllerId());
        if (targetPlayer != null) {
            targetPlayer.loseLife(1, game, source, false);
        }
        if (you != null) {
            you.gainLife(1, game, source);
        }
        return true;
    }

    public SludgeStriderEffect copy() {
        return new SludgeStriderEffect(this);
    }
}

