/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.DiscardTargetCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SlumberingToraEffect
extends ContinuousEffectImpl {
    private int convManaCosts = 0;

    SlumberingToraEffect() {
        super(Duration.EndOfTurn, Outcome.BecomeCreature);
        this.staticText = "{this} becomes an X/X Cat artifact creature until end of turn, where X is the discarded card's mana value";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private SlumberingToraEffect(SlumberingToraEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.convManaCosts = effect.convManaCosts;
    }

    public SlumberingToraEffect copy() {
        return new SlumberingToraEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof DiscardTargetCost) || ((DiscardTargetCost)cost).getCards().isEmpty()) continue;
            this.convManaCosts = ((Card)((DiscardTargetCost)cost).getCards().get(0)).getManaValue();
            return;
        }
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.addCardType(game, new CardType[]{CardType.ARTIFACT});
                permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                permanent.addSubType(game, new SubType[]{SubType.CAT});
                break;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(this.convManaCosts);
                permanent.getToughness().setModifiedBaseValue(this.convManaCosts);
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.TypeChangingEffects_4;
    }
}

