/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SmeagolHelpfulGuideEffect
extends OneShotEffect {
    SmeagolHelpfulGuideEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "target opponent reveals cards from the top of their library until they reveal a land card. Put that card onto the battlefield tapped under your control and the rest into their graveyard.";
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (opponent == null || controller == null) {
            return false;
        }
        CardsImpl revealed = new CardsImpl();
        Card land = null;
        for (Card card : opponent.getLibrary().getCards(game)) {
            if (card == null) continue;
            revealed.add(card);
            if (!card.isLand(game)) continue;
            land = card;
            break;
        }
        opponent.revealCards(source, (Cards)revealed, game);
        if (land != null) {
            revealed.remove(land);
            controller.moveCards(land, Zone.BATTLEFIELD, source, game, true, false, false, null);
        }
        opponent.moveCards((Cards)revealed, Zone.GRAVEYARD, source, game);
        return true;
    }

    private SmeagolHelpfulGuideEffect(SmeagolHelpfulGuideEffect effect) {
        super((OneShotEffect)effect);
    }

    public SmeagolHelpfulGuideEffect copy() {
        return new SmeagolHelpfulGuideEffect(this);
    }
}

