/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.util.ManaUtil;

class SmotheringTitheEffect
extends OneShotEffect {
    SmotheringTitheEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player may pay {2}. If the player doesn't, you create a Treasure token";
    }

    private SmotheringTitheEffect(SmotheringTitheEffect effect) {
        super((OneShotEffect)effect);
    }

    public SmotheringTitheEffect copy() {
        return new SmotheringTitheEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        ManaCost cost = ManaUtil.createManaCost((int)2, (boolean)false);
        if (!player.chooseUse(Outcome.Detriment, "Pay {2} to prevent this effect?", source, game) || !cost.pay(source, game, source, player.getId(), false)) {
            return new TreasureToken().putOntoBattlefield(1, game, source, source.getControllerId());
        }
        return false;
    }
}

