/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.CardsAmountDrawnThisTurnWatcher;

enum SmugglersShareDrawValue implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability source, Effect effect) {
        Player controller = game.getPlayer(source.getControllerId());
        CardsAmountDrawnThisTurnWatcher watcher = (CardsAmountDrawnThisTurnWatcher)game.getState().getWatcher(CardsAmountDrawnThisTurnWatcher.class);
        if (watcher == null || controller == null) {
            return 0;
        }
        int drawCount = 0;
        for (UUID opponentId : game.getOpponents(controller.getId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || watcher.getAmountCardsDrawn(opponentId) < 2) continue;
            ++drawCount;
        }
        return drawCount;
    }

    public SmugglersShareDrawValue copy() {
        return instance;
    }

    public String getMessage() {
        return "opponent who drew two or more cards this turn";
    }

    public String toString() {
        return "1";
    }
}

