/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class SolKanarTheTaintedEffect
extends OneShotEffect {
    SolKanarTheTaintedEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile {this}, then return it to the battlefield under an opponent's control";
    }

    private SolKanarTheTaintedEffect(SolKanarTheTaintedEffect effect) {
        super((OneShotEffect)effect);
    }

    public SolKanarTheTaintedEffect copy() {
        return new SolKanarTheTaintedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Player player = game.getPlayer(source.getControllerId());
        if (permanent == null || player == null) {
            return false;
        }
        Card card = permanent.getMainCard();
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        if (card instanceof PermanentToken) {
            return true;
        }
        TargetOpponent target = new TargetOpponent(true);
        player.choose(this.outcome, (Target)target, source, game);
        Player opponent = game.getPlayer(target.getFirstTarget());
        return opponent == null || opponent.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

