/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SolemnityEffect2
extends ReplacementEffectImpl {
    private static final FilterPermanent filter = new FilterPermanent();

    public SolemnityEffect2() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Counters can't be put on artifacts, creatures, enchantments, or lands";
    }

    private SolemnityEffect2(SolemnityEffect2 effect) {
        super((ReplacementEffectImpl)effect);
    }

    public SolemnityEffect2 copy() {
        return new SolemnityEffect2(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getTargetId());
        Permanent permanent1 = game.getPermanentEntering(event.getTargetId());
        Permanent permanent2 = game.getPermanent(event.getTargetId());
        if (object instanceof Permanent) {
            return filter.match((Object)((Permanent)object), game);
        }
        if (permanent1 != null) {
            return filter.match((Object)permanent1, game);
        }
        if (permanent2 != null) {
            return filter.match((Object)permanent2, game);
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.ENCHANTMENT.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

