/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

class SomnophoreTriggeredAbility
extends TriggeredAbilityImpl {
    public SomnophoreTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect);
        this.addTarget((Target)new TargetCreaturePermanent());
    }

    private SomnophoreTriggeredAbility(SomnophoreTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SomnophoreTriggeredAbility copy() {
        return new SomnophoreTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player opponent;
        if (event.getSourceId().equals(this.getSourceId()) && (opponent = game.getPlayer(event.getPlayerId())) != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent("creature " + opponent.getLogName() + " controls");
            filter.add((Predicate)new ControllerIdPredicate(opponent.getId()));
            this.getTargets().clear();
            this.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} deals damage to a player, tap target creature that player controls. That creature doesn't untap during its controller's untap step for as long as {this} remains on the battlefield.";
    }
}

