/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.EnchantedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SongOfSerenityRestrictionEffect
extends RestrictionEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public SongOfSerenityRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Creatures that are enchanted can't attack or block";
    }

    private SongOfSerenityRestrictionEffect(SongOfSerenityRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public SongOfSerenityRestrictionEffect copy() {
        return new SongOfSerenityRestrictionEffect(this);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return filter.match(permanent, source.getControllerId(), source, game);
    }

    static {
        filter.add((Predicate)EnchantedPredicate.instance);
    }
}

