/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.InstantAndSorceryCastThisTurn;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class SorcererClassEffect
extends OneShotEffect {
    SorcererClassEffect() {
        super(Outcome.Benefit);
        this.staticText = "that spell deals damage to each opponent equal to the number of instant and sorcery spells you've cast this turn";
    }

    private SorcererClassEffect(SorcererClassEffect effect) {
        super((OneShotEffect)effect);
    }

    public SorcererClassEffect copy() {
        return new SorcererClassEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = (Spell)this.getValue("spellCast");
        if (spell == null) {
            return false;
        }
        int count = InstantAndSorceryCastThisTurn.YOU.calculate(game, source, (Effect)this);
        if (count < 1) {
            return false;
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.damage(count, spell.getId(), source, game);
        }
        return true;
    }
}

