/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SorinGrimNemesisRevealEffect
extends OneShotEffect {
    public SorinGrimNemesisRevealEffect() {
        super(Outcome.DrawCard);
        this.staticText = "reveal the top card of your library and put that card into your hand. Each opponent loses life equal to its mana value";
    }

    private SorinGrimNemesisRevealEffect(SorinGrimNemesisRevealEffect effect) {
        super((OneShotEffect)effect);
    }

    public SorinGrimNemesisRevealEffect copy() {
        return new SorinGrimNemesisRevealEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (controller.getLibrary().hasCards() && (card = controller.getLibrary().getFromTop(game)) != null) {
            CardsImpl cards = new CardsImpl();
            cards.add(card);
            controller.revealCards("Sorin, Grim Nemesis", (Cards)cards, game);
            if (controller.moveCards(card, Zone.HAND, source, game)) {
                for (UUID playerId : game.getOpponents(source.getControllerId())) {
                    Player opponent;
                    if (card.getManaValue() <= 0 || (opponent = game.getPlayer(playerId)) == null) continue;
                    opponent.loseLife(card.getManaValue(), game, source, false);
                }
                return true;
            }
        }
        return false;
    }
}

