/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.ControllerGainedLifeCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTypeTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.abilities.keyword.ExtortAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.s.SorinRavenousNeonatePredicate;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.permanent.token.FoodToken;
import mage.game.permanent.token.Token;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;
import mage.target.common.TargetCreaturePermanent;
import mage.watchers.Watcher;
import mage.watchers.common.PlayerGainedLifeWatcher;

public final class SorinRavenousNeonate
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("white permanent other than that creature or {this}");
    private static final Condition condition = new PermanentsOnTheBattlefieldCondition(filter, true);
    private static final Hint hint = new ConditionHint(condition, "you control another white permanent");

    public SorinRavenousNeonate(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.SORIN);
        this.setStartingLoyalty(3);
        this.color.setWhite(true);
        this.color.setBlack(true);
        this.nightCard = true;
        this.addAbility((Ability)new ExtortAbility());
        this.addAbility((Ability)new LoyaltyAbility((Effect)new CreateTokenEffect((Token)new FoodToken()), 2));
        LoyaltyAbility ability = new LoyaltyAbility((Effect)new DamageTargetEffect((DynamicValue)ControllerGainedLifeCount.instance).setText("{this} deals damage equal to the amount of life you gained this turn to any target"), -1);
        ability.addTarget((Target)new TargetAnyTarget());
        this.addAbility(ability.addHint(ControllerGainedLifeCount.getHint()), (Watcher)new PlayerGainedLifeWatcher());
        ability = new LoyaltyAbility((Effect)new GainControlTargetEffect(Duration.EndOfGame), -6);
        ability.addTarget((Target)new TargetCreaturePermanent());
        ability.addEffect((Effect)new BecomesCreatureTypeTargetEffect(Duration.EndOfGame, SubType.VAMPIRE, false).setText("It becomes a Vampire in addition to its other types"));
        ability.addEffect((Effect)new ConditionalOneShotEffect((OneShotEffect)new AddCountersTargetEffect(CounterType.LIFELINK.createInstance()), condition, "Put a lifelink counter on it if you control a white permanent other than that creature or {this}"));
        this.addAbility(ability.addHint(hint));
    }

    private SorinRavenousNeonate(SorinRavenousNeonate card) {
        super((CardImpl)card);
    }

    public SorinRavenousNeonate copy() {
        return new SorinRavenousNeonate(this);
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.WHITE));
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.add((ObjectSourcePlayerPredicate)SorinRavenousNeonatePredicate.instance);
    }
}

