/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;
import mage.util.RandomUtil;

class SotheraTheSupervoidReturnEffect
extends OneShotEffect {
    SotheraTheSupervoidReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then put a creature card exiled with it onto the battlefield under your control with two additional +1/+1 counters on it";
    }

    private SotheraTheSupervoidReturnEffect(SotheraTheSupervoidReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public SotheraTheSupervoidReturnEffect copy() {
        return new SotheraTheSupervoidReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (player == null || exileZone == null) {
            return false;
        }
        switch (exileZone.count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game)) {
            case 0: {
                return false;
            }
            case 1: {
                card = (Card)RandomUtil.randomFromCollection((Collection)exileZone.getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
                break;
            }
            default: {
                TargetCardInExile target = new TargetCardInExile((FilterCard)StaticFilters.FILTER_CARD_CREATURE, exileZone.getId());
                player.choose(this.outcome, (Target)target, source, game);
                card = game.getCard(target.getFirstTarget());
            }
        }
        if (card == null) {
            return false;
        }
        game.setEnterWithCounters(card.getId(), new Counters(new Counter[]{CounterType.P1P1.createInstance(2)}));
        return player.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

