/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SoulBurnEffect
extends OneShotEffect {
    SoulBurnEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to any target. You gain life equal to the damage dealt, but not more than the amount of {B} spent on X, the player's life total before the damage was dealt, the planeswalker's loyalty before the damage was dealt, or the creature's toughness.";
    }

    private SoulBurnEffect(SoulBurnEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int amountBlack = source.getManaCostsToPay().getUsedManaToPay().getBlack();
        int amountRed = source.getManaCostsToPay().getUsedManaToPay().getRed();
        int amountWhite = source.getManaCostsToPay().getUsedManaToPay().getWhite();
        int amountGreen = source.getManaCostsToPay().getUsedManaToPay().getGreen();
        int amountBlue = source.getManaCostsToPay().getUsedManaToPay().getBlue();
        int amountColorless = source.getManaCostsToPay().getUsedManaToPay().getColorless();
        int totalColorlessForCastingCost = amountWhite + amountGreen + amountBlue + amountColorless;
        int amountOffsetByColorless = 0;
        if (totalColorlessForCastingCost > 0 && (amountOffsetByColorless = totalColorlessForCastingCost) > 2) {
            amountOffsetByColorless = 2;
        }
        --amountBlack;
        if (amountOffsetByColorless < 2) {
            int amountToOffsetBy = 2 - amountOffsetByColorless;
            if (amountRed > 0) {
                if (amountRed >= amountToOffsetBy) {
                    amountRed -= amountToOffsetBy;
                } else {
                    --amountRed;
                    --amountBlack;
                }
            } else {
                amountBlack -= amountToOffsetBy;
            }
        }
        int totalXAmount = amountBlack + amountRed;
        int lifetogain = amountBlack;
        if (totalXAmount == 0) {
            return false;
        }
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            if (permanent.isCreature(game)) {
                lifetogain = Math.min(permanent.getToughness().getValue(), lifetogain);
            } else if (permanent.isPlaneswalker(game)) {
                lifetogain = Math.min(permanent.getCounters(game).getCount(CounterType.LOYALTY), lifetogain);
            } else {
                return false;
            }
            permanent.damage(totalXAmount, source.getSourceId(), source, game);
        } else {
            Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (player == null) {
                return false;
            }
            lifetogain = Math.min(player.getLife(), lifetogain);
            player.damage(totalXAmount, source.getSourceId(), source, game);
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.gainLife(lifetogain, game, source);
        return true;
    }

    public SoulBurnEffect copy() {
        return new SoulBurnEffect(this);
    }
}

