/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.s.SoulEchoReplacementEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SoulEchoOpponentsChoiceEffect
extends OneShotEffect {
    SoulEchoOpponentsChoiceEffect() {
        super(Outcome.PreventDamage);
        this.staticText = "target opponent may choose that for each 1 damage that would be dealt to you until your next upkeep, you remove an echo counter from {this} instead";
    }

    private SoulEchoOpponentsChoiceEffect(SoulEchoOpponentsChoiceEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulEchoOpponentsChoiceEffect copy() {
        return new SoulEchoOpponentsChoiceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && opponent != null && permanent != null) {
            if (opponent.chooseUse(this.outcome, "Have all damage dealt to " + controller.getLogName() + " be decremented from echo counters on " + permanent.getLogName() + " until " + controller.getLogName() + "'s next upkeep instead?", source, game)) {
                game.informPlayers("Until " + controller.getLogName() + "'s next upkeep, for each 1 damage that would be dealt to " + controller.getLogName() + ", an echo counter from " + permanent.getLogName() + " is removed instead");
                game.addEffect((ContinuousEffect)new SoulEchoReplacementEffect(), source);
            }
            return true;
        }
        return false;
    }
}

