/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SoulRendEffect
extends OneShotEffect {
    SoulRendEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy target creature if it's white. A creature destroyed this way can't be regenerated";
    }

    private SoulRendEffect(SoulRendEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && permanent.getColor(game).isWhite()) {
            permanent.destroy(source, game, true);
        }
        return false;
    }

    public SoulRendEffect copy() {
        return new SoulRendEffect(this);
    }
}

