/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.condition.Condition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToHandTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.s.SoulTransferCondition;
import mage.constants.CardType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetCreatureOrPlaneswalker;

public final class SoulTransfer
extends CardImpl {
    private static final FilterCard filter = new FilterCard("creature or planeswalker card from your graveyard");

    public SoulTransfer(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{1}{B}{B}");
        this.getSpellAbility().getModes().setChooseText("Choose one. If you control an artifact and an enchantment as you cast this spell, you may choose both.");
        this.getSpellAbility().getModes().setMoreCondition(2, (Condition)SoulTransferCondition.instance);
        this.getSpellAbility().addEffect((Effect)new ExileTargetEffect());
        this.getSpellAbility().addTarget((Target)new TargetCreatureOrPlaneswalker());
        Mode mode = new Mode((Effect)new ReturnFromGraveyardToHandTargetEffect());
        mode.addTarget((Target)new TargetCardInYourGraveyard(filter));
        this.getSpellAbility().addMode(mode);
    }

    private SoulTransfer(SoulTransfer card) {
        super((CardImpl)card);
    }

    public SoulTransfer copy() {
        return new SoulTransfer(this);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
    }
}

