/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

class SoulfireGrandMasterCastFromHandReplacementEffect
extends ReplacementEffectImpl {
    private static final FilterCard filter = new FilterCard();
    private UUID spellId;

    SoulfireGrandMasterCastFromHandReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.ReturnToHand);
        this.spellId = null;
        this.staticText = "The next time you cast an instant or sorcery spell from your hand this turn, put that card into your hand instead of into your graveyard as it resolves";
    }

    private SoulfireGrandMasterCastFromHandReplacementEffect(SoulfireGrandMasterCastFromHandReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.spellId = effect.spellId;
    }

    public SoulfireGrandMasterCastFromHandReplacementEffect copy() {
        return new SoulfireGrandMasterCastFromHandReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player;
        Card sourceCard;
        Spell spell;
        StackObject stackObject = game.getStack().getFirstOrNull();
        if (stackObject instanceof Spell && !(spell = (Spell)stackObject).isCopy() && !spell.isCountered() && (sourceCard = game.getCard(this.spellId)) != null && Zone.STACK.equals((Object)game.getState().getZone(this.spellId)) && (player = game.getPlayer(sourceCard.getOwnerId())) != null) {
            player.moveCards(sourceCard, Zone.HAND, source, game);
            this.discard();
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (this.spellId == null && zEvent.getFromZone() == Zone.HAND && zEvent.getToZone() == Zone.STACK && event.getPlayerId().equals(source.getControllerId())) {
            MageObject object = game.getObject(event.getTargetId());
            if (object instanceof Card && filter.match((Card)object, game)) {
                this.spellId = event.getTargetId();
            }
        } else if (zEvent.getFromZone() == Zone.STACK && zEvent.getToZone() == Zone.GRAVEYARD && event.getTargetId().equals(this.spellId) && game.getStack().getFirstOrNull() instanceof Spell) {
            Card cardOfSpell = ((Spell)game.getStack().getFirstOrNull()).getCard();
            return cardOfSpell.getMainCard().getId().equals(this.spellId);
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.INSTANT.getPredicate(), (Predicate)CardType.SORCERY.getPredicate()));
    }
}

