/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SoulgorgerOrggLoseLifeEffect
extends OneShotEffect {
    SoulgorgerOrggLoseLifeEffect() {
        super(Outcome.LoseLife);
        this.staticText = "you lose all but 1 life";
    }

    private SoulgorgerOrggLoseLifeEffect(SoulgorgerOrggLoseLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulgorgerOrggLoseLifeEffect copy() {
        return new SoulgorgerOrggLoseLifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            int lifeValue = 0;
            if (player.getLife() > 1) {
                lifeValue = player.getLife() - 1;
            }
            game.getState().setValue(source.getSourceId().toString() + source.getControllerId().toString() + source.getStackMomentSourceZCC() + "_lifeValue", (Object)lifeValue);
            if (lifeValue > 0) {
                player.loseLife(lifeValue, game, source, false);
            }
        }
        return true;
    }
}

