/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class SoullessOneDynamicCount
implements DynamicValue {
    SoullessOneDynamicCount() {
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        FilterPermanent zombiesBattlefield = new FilterPermanent("Zombies on the battlefield");
        FilterCard zombiesInGraveyard = new FilterCard("Zombie cards in all graveyards");
        zombiesBattlefield.add((Predicate)SubType.ZOMBIE.getPredicate());
        zombiesInGraveyard.add((Predicate)SubType.ZOMBIE.getPredicate());
        int count = game.getBattlefield().count(zombiesBattlefield, sourceAbility.getControllerId(), sourceAbility, game);
        for (UUID playerId : game.getState().getPlayersInRange(sourceAbility.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            count += player.getGraveyard().count(zombiesInGraveyard, game);
        }
        return count;
    }

    public SoullessOneDynamicCount copy() {
        return new SoullessOneDynamicCount();
    }

    public String getMessage() {
        return "Zombies on the battlefield plus the number of Zombie cards in all graveyards";
    }

    public String toString() {
        return "1";
    }
}

