/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SoulsGraceEffect
extends OneShotEffect {
    SoulsGraceEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain life equal to target creature's power";
    }

    private SoulsGraceEffect(SoulsGraceEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulsGraceEffect copy() {
        return new SoulsGraceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount;
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        Player player = game.getPlayer(source.getControllerId());
        if (permanent != null && player != null && (amount = permanent.getPower().getValue()) > 0) {
            player.gainLife(amount, game, source);
            return true;
        }
        return false;
    }
}

