/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

public final class SoulsMajesty
extends CardImpl {
    public SoulsMajesty(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{4}{G}");
        this.getSpellAbility().addTarget((Target)new TargetControlledCreaturePermanent());
        this.getSpellAbility().addEffect((Effect)new SoulsMajestyEffect());
    }

    private SoulsMajesty(SoulsMajesty card) {
        super((CardImpl)card);
    }

    public SoulsMajesty copy() {
        return new SoulsMajesty(this);
    }

    private static class SoulsMajestyEffect
    extends OneShotEffect {
        public SoulsMajestyEffect() {
            super(Outcome.DrawCard);
            this.staticText = "Draw cards equal to the power of target creature you control";
        }

        private SoulsMajestyEffect(SoulsMajestyEffect effect) {
            super((OneShotEffect)effect);
        }

        public boolean apply(Game game, Ability source) {
            Permanent target = game.getPermanent(source.getFirstTarget());
            Player player = game.getPlayer(source.getControllerId());
            if (player != null && target != null) {
                player.drawCards(target.getPower().getValue(), source, game);
                return true;
            }
            return false;
        }

        public SoulsMajestyEffect copy() {
            return new SoulsMajestyEffect(this);
        }
    }
}

