/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SowerOfDiscordTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPlayerEvent> {
    SowerOfDiscordTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
    }

    private SowerOfDiscordTriggeredAbility(SowerOfDiscordTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SowerOfDiscordTriggeredAbility copy() {
        return new SowerOfDiscordTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        int damage = event.getAmount();
        Player player1 = (Player)game.getState().getValue(this.getSourceId() + "_player1");
        Player player2 = (Player)game.getState().getValue(this.getSourceId() + "_player2");
        if (player1 == null || player2 == null || damage == 0) {
            return false;
        }
        LoseLifeTargetEffect effect = new LoseLifeTargetEffect(damage);
        if (event.getTargetId().equals(player1.getId())) {
            this.getEffects().clear();
            effect.setTargetPointer((TargetPointer)new FixedTarget(player2.getId()));
            this.addEffect((Effect)effect);
            return true;
        }
        if (event.getTargetId().equals(player2.getId())) {
            this.getEffects().clear();
            effect.setTargetPointer((TargetPointer)new FixedTarget(player1.getId()));
            this.addEffect((Effect)effect);
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever damage is dealt to one of the chosen players, the other chosen player also loses that much life.";
    }
}

