/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterPlaneswalkerPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SparkRuptureEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterPlaneswalkerPermanent();

    SparkRuptureEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "each planeswalker with one or more loyalty counters on it loses all abilities and is a creature with power and toughness each equal to the number of loyalty counters on it";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private SparkRuptureEffect(SparkRuptureEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SparkRuptureEffect copy() {
        return new SparkRuptureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        switch (layer) {
            case TypeChangingEffects_4: {
                this.affectedObjectList.clear();
                for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
                    this.affectedObjectList.add(new MageObjectReference((MageObject)permanent, game));
                    permanent.removeAllCardTypes(game);
                    permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                }
                return true;
            }
            case AbilityAddingRemovingEffects_6: {
                for (MageObjectReference mor : this.getAffectedObjects()) {
                    Permanent permanent = mor.getPermanent(game);
                    if (permanent == null) continue;
                    int counters = permanent.getCounters(game).getCount(CounterType.LOYALTY);
                    permanent.getPower().setModifiedBaseValue(counters);
                    permanent.getToughness().setModifiedBaseValue(counters);
                }
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) {
                    return false;
                }
                for (MageObjectReference mor : this.getAffectedObjects()) {
                    Permanent permanent = mor.getPermanent(game);
                    if (permanent == null) continue;
                    permanent.removeAllAbilities(source.getSourceId(), game);
                }
                return true;
            }
        }
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case AbilityAddingRemovingEffects_6: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }

    static {
        filter.add((Predicate)CounterType.LOYALTY.getPredicate());
    }
}

