/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.GoadTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class SpectacularShowdownOverloadEffect
extends OneShotEffect {
    SpectacularShowdownOverloadEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a double strike counter on each creature, then goad each creature that had a double strike counter put on it this way";
    }

    private SpectacularShowdownOverloadEffect(SpectacularShowdownOverloadEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpectacularShowdownOverloadEffect copy() {
        return new SpectacularShowdownOverloadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game).stream().filter(permanent -> permanent.addCounters(CounterType.DOUBLE_STRIKE.createInstance(), source, game)).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            return false;
        }
        game.addEffect(new GoadTargetEffect().setTargetPointer((TargetPointer)new FixedTargets(permanents, game)), source);
        return true;
    }
}

