/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CounterUnlessPaysEffect;
import mage.abilities.effects.common.cost.SpellCostReductionForEachSourceEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.target.Target;
import mage.target.TargetSpell;

public final class SpectralDenial
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("creature you control with power 4 or greater");
    private static final DynamicValue xValue;
    private static final Hint hint;

    public SpectralDenial(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{X}{U}");
        this.addAbility(new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionForEachSourceEffect(1, xValue)).addHint(hint));
        this.getSpellAbility().addEffect((Effect)new CounterUnlessPaysEffect((DynamicValue)GetXValue.instance));
        this.getSpellAbility().addTarget((Target)new TargetSpell());
    }

    private SpectralDenial(SpectralDenial card) {
        super((CardImpl)card);
    }

    public SpectralDenial copy() {
        return new SpectralDenial(this);
    }

    static {
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 3));
        xValue = new PermanentsOnBattlefieldCount(filter, Integer.valueOf(1));
        hint = new ValueHint("Creatures you control with power 4 or greater", xValue);
    }
}

