/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DontUntapInControllersNextUntapStepSourceEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;

class SpectralForceTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterPermanent filter = new FilterPermanent("black permanents");

    public SpectralForceTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DontUntapInControllersNextUntapStepSourceEffect());
    }

    private SpectralForceTriggeredAbility(SpectralForceTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SpectralForceTriggeredAbility copy() {
        return new SpectralForceTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getSourceId().equals(this.getSourceId());
    }

    public boolean checkInterveningIfClause(Game game) {
        UUID defendingPlayerId = game.getCombat().getDefendingPlayerId(this.getSourceId(), game);
        return defendingPlayerId != null && game.getBattlefield().countAll(filter, defendingPlayerId, game) < 1;
    }

    public String getRule() {
        return "Whenever {this} attacks, if defending player controls no black permanents, it doesn't untap during your next untap step.";
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.BLACK));
    }
}

