/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class SpellQuellerEntersEffect
extends OneShotEffect {
    SpellQuellerEntersEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target spell with mana value 4 or less";
    }

    private SpellQuellerEntersEffect(SpellQuellerEntersEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpellQuellerEntersEffect copy() {
        return new SpellQuellerEntersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
            if (spell != null) {
                UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
                return controller.moveCardsToExile((Card)spell, source, game, true, exileId, sourceObject.getIdName());
            }
            return true;
        }
        return false;
    }
}

