/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class SpellboundDragonEffect
extends OneShotEffect {
    SpellboundDragonEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "draw a card, then discard a card. {this} gets +X/+0 until end of turn, where X is the discarded card's mana value";
    }

    private SpellboundDragonEffect(SpellboundDragonEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpellboundDragonEffect copy() {
        return new SpellboundDragonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        Permanent dragon = game.getPermanent(source.getSourceId());
        if (you != null) {
            you.drawCards(1, source, game);
            TargetDiscard target = new TargetDiscard(you.getId());
            you.choose(Outcome.Discard, (Target)target, source, game);
            Card card = you.getHand().get(target.getFirstTarget(), game);
            if (card != null && you.discard(card, false, source, game)) {
                int cmc = card.getManaValue();
                if (dragon != null) {
                    game.addEffect((ContinuousEffect)new BoostSourceEffect(cmc, 0, Duration.EndOfTurn), source);
                    return true;
                }
            }
        }
        return false;
    }
}

