/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SpelljackEffect
extends OneShotEffect {
    SpelljackEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Counter target spell. If that spell is countered this way, exile it instead of putting it into its owner's graveyard. You may play it without paying its mana cost for as long as it remains exiled";
    }

    private SpelljackEffect(SpelljackEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpelljackEffect copy() {
        return new SpelljackEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card;
            UUID targetId = this.getTargetPointer().getFirst(game, source);
            StackObject stackObject = game.getStack().getStackObject(targetId);
            if (stackObject != null && game.getStack().counter(targetId, source, game, PutCards.EXILED) && (card = ((Spell)stackObject).getCard()) != null) {
                PlayFromNotOwnHandZoneTargetEffect effect = new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, TargetController.YOU, Duration.Custom, true);
                effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game.getState().getZoneChangeCounter(card.getId())));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

