/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SpellweaverHelixCastEffect
extends OneShotEffect {
    private String spellName = "";

    SpellweaverHelixCastEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may copy the other. If you do, you may cast the copy without paying its mana cost";
    }

    private SpellweaverHelixCastEffect(SpellweaverHelixCastEffect effect) {
        super((OneShotEffect)effect);
        this.spellName = effect.spellName;
    }

    public SpellweaverHelixCastEffect copy() {
        return new SpellweaverHelixCastEffect(this);
    }

    public void setSpellName(String spellName) {
        this.spellName = spellName;
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
            if (sourcePermanent != null) {
                boolean foundSpellWithSameName = false;
                for (UUID imprintId : sourcePermanent.getImprinted()) {
                    Card card = game.getCard(imprintId);
                    if (card == null) continue;
                    if (!foundSpellWithSameName && card.getName().equals(this.spellName)) {
                        foundSpellWithSameName = true;
                        continue;
                    }
                    if (!controller.chooseUse(Outcome.Copy, "Copy " + card.getIdName(), source, game)) continue;
                    Card copy = game.copyCard(card, source, source.getControllerId());
                    if (!controller.chooseUse(Outcome.PlayForFree, "Cast " + copy.getIdName() + " without paying its mana cost?", source, game)) continue;
                    game.getState().setValue("PlayFromNotOwnHandZone" + copy.getId(), (Object)Boolean.TRUE);
                    controller.cast(controller.chooseAbilityForCast(copy, game, true), game, true, new ApprovingObject(source, game));
                    game.getState().setValue("PlayFromNotOwnHandZone" + copy.getId(), null);
                }
            }
            return true;
        }
        return false;
    }
}

