/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.combat.CantAttackYouUnlessPayAllEffect;
import mage.cards.s.NumberOfEnchantmentsYouControl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class SphereOfSafetyPayManaToAttackAllEffect
extends CantAttackYouUnlessPayAllEffect {
    SphereOfSafetyPayManaToAttackAllEffect() {
        super(Duration.WhileOnBattlefield, (Cost)new ManaCostsImpl("{X}"), CantAttackYouUnlessPayAllEffect.Scope.YOU_AND_CONTROLLED_PLANESWALKERS);
        this.staticText = "Creatures can't attack you or planeswalkers you control unless their controller pays {X} for each of those creatures, where X is the number of enchantments you control.";
    }

    private SphereOfSafetyPayManaToAttackAllEffect(SphereOfSafetyPayManaToAttackAllEffect effect) {
        super((CantAttackYouUnlessPayAllEffect)effect);
    }

    public ManaCosts getManaCostToPay(GameEvent event, Ability source, Game game) {
        int enchantments = NumberOfEnchantmentsYouControl.instance.calculate(game, source, (Effect)this);
        if (enchantments > 0) {
            return new ManaCostsImpl("{" + enchantments + '}');
        }
        return null;
    }

    public SphereOfSafetyPayManaToAttackAllEffect copy() {
        return new SphereOfSafetyPayManaToAttackAllEffect(this);
    }
}

