/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class SphinxsDecreeCantCastEffect
extends ContinuousRuleModifyingEffectImpl {
    int playersNextTurn;

    public SphinxsDecreeCantCastEffect() {
        super(Duration.Custom, Outcome.Detriment);
        this.staticText = "You can't cast instant or sorcery spells during this turn";
        this.playersNextTurn = 0;
    }

    private SphinxsDecreeCantCastEffect(SphinxsDecreeCantCastEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
        this.playersNextTurn = effect.playersNextTurn;
    }

    public SphinxsDecreeCantCastEffect copy() {
        return new SphinxsDecreeCantCastEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast instant or sorcery spells this turn (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        UUID opponentId = this.getTargetPointer().getFirst(game, source);
        if (game.isActivePlayer(opponentId)) {
            if (this.playersNextTurn == 0) {
                this.playersNextTurn = game.getTurnNum();
            }
            if (this.playersNextTurn == game.getTurnNum()) {
                if (opponentId.equals(event.getPlayerId())) {
                    MageObject object = game.getObject(event.getSourceId());
                    if (event.getType() == GameEvent.EventType.CAST_SPELL && object != null && object.isInstantOrSorcery(game)) {
                        return true;
                    }
                }
            } else {
                this.discard();
            }
        } else if (this.playersNextTurn > 0) {
            this.discard();
        }
        return false;
    }
}

