/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class SpiderMan2099Watcher
extends Watcher {
    private final Set<UUID> set = new HashSet<UUID>();

    SpiderMan2099Watcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case LAND_PLAYED: {
                if (Zone.HAND.match(event.getZone())) break;
                this.set.add(event.getPlayerId());
                break;
            }
            case SPELL_CAST: {
                Spell spell = game.getSpell(event.getTargetId());
                if (spell == null || Zone.HAND.match(spell.getFromZone())) break;
                this.set.add(spell.getControllerId());
            }
        }
    }

    public void reset() {
        super.reset();
        this.set.clear();
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((SpiderMan2099Watcher)game.getState().getWatcher(SpiderMan2099Watcher.class)).set.contains(source.getControllerId());
    }
}

