/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.SecondTargetPointer;
import mage.target.targetpointer.TargetPointer;

class SpinningWheelKickEffect
extends OneShotEffect {
    SpinningWheelKickEffect() {
        super(Outcome.Benefit);
        this.staticText = "target creature you control deals damage equal to its power to each of X target creatures and/or planeswalkers";
        this.setTargetPointer((TargetPointer)new SecondTargetPointer());
    }

    private SpinningWheelKickEffect(SpinningWheelKickEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpinningWheelKickEffect copy() {
        return new SpinningWheelKickEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (creature == null) {
            return false;
        }
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            permanent.damage(creature.getPower().getValue(), creature.getId(), source, game);
        }
        return true;
    }
}

