/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapTargetCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.AddCardTypeSourceEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.keyword.CrewAbility;
import mage.abilities.keyword.ExhaustAbility;
import mage.abilities.keyword.HasteAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.target.common.TargetControlledPermanent;

public final class SpireMechcycle
extends CardImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("another untapped Mount or Vehicle you control");
    private static final FilterControlledPermanent mountAndVehicleFilter = new FilterControlledPermanent("Mount and/or Vehicle you control other than this Vehicle");
    private static final DynamicValue mountAndVehicleCount = new PermanentsOnBattlefieldCount((FilterPermanent)mountAndVehicleFilter);

    public SpireMechcycle(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{4}{R}");
        this.subtype.add((Object)SubType.VEHICLE);
        this.power = new MageInt(5);
        this.toughness = new MageInt(4);
        this.addAbility((Ability)HasteAbility.getInstance());
        ContinuousEffect effect = new AddCardTypeSourceEffect(Duration.WhileOnBattlefield, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}).setText("This Vehicle becomes an artifact creature");
        ExhaustAbility ability = new ExhaustAbility((Effect)effect, (Cost)new TapTargetCost(new TargetControlledPermanent(filter)));
        ability.addEffect((Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance(), mountAndVehicleCount).setText("Put a +1/+1 counter on it for each Mount and/or Vehicle you control other than this Vehicle"));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new CrewAbility(2));
    }

    private SpireMechcycle(SpireMechcycle card) {
        super((CardImpl)card);
    }

    public SpireMechcycle copy() {
        return new SpireMechcycle(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.add((Predicate)TappedPredicate.UNTAPPED);
        filter.add(Predicates.or((Predicate)SubType.MOUNT.getPredicate(), (Predicate)SubType.VEHICLE.getPredicate()));
        mountAndVehicleFilter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        mountAndVehicleFilter.add(Predicates.or((Predicate)SubType.MOUNT.getPredicate(), (Predicate)SubType.VEHICLE.getPredicate()));
    }
}

