/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.replacement.LeaveBattlefieldExileSourceReplacementEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class SpiritSistersCallReturnToBattlefieldEffect
extends OneShotEffect {
    SpiritSistersCallReturnToBattlefieldEffect() {
        super(Outcome.PutCardInPlay);
    }

    private SpiritSistersCallReturnToBattlefieldEffect(SpiritSistersCallReturnToBattlefieldEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpiritSistersCallReturnToBattlefieldEffect copy() {
        return new SpiritSistersCallReturnToBattlefieldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (controller == null || card == null || game.getState().getZone(card.getId()) != Zone.GRAVEYARD) {
            return false;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent != null) {
            GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)new SimpleStaticAbility((Effect)new LeaveBattlefieldExileSourceReplacementEffect("this permanent")), Duration.Custom);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

