/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class SpitefulRepossessionEffect
extends OneShotEffect {
    SpitefulRepossessionEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals damage to each opponent who controls more lands than you equal to the difference. Then create a number of Treasure tokens equal to the damage dealt this way";
    }

    private SpitefulRepossessionEffect(SpitefulRepossessionEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpitefulRepossessionEffect copy() {
        return new SpitefulRepossessionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int controlledLands = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, source.getControllerId(), source, game);
        int damageDealt = 0;
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent;
            int lands = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, opponentId, source, game);
            if (lands <= controlledLands || (opponent = game.getPlayer(opponentId)) == null) continue;
            damageDealt += opponent.damage(lands - controlledLands, source, game);
        }
        if (damageDealt > 0) {
            new TreasureToken().putOntoBattlefield(damageDealt, game, source);
        }
        return true;
    }
}

