/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SpitefulVisionsTriggeredAbility
extends TriggeredAbilityImpl {
    public SpitefulVisionsTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
    }

    private SpitefulVisionsTriggeredAbility(SpitefulVisionsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DREW_CARD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getPlayerId() != null) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a player draws a card, {this} deals 1 damage to that player.";
    }

    public SpitefulVisionsTriggeredAbility copy() {
        return new SpitefulVisionsTriggeredAbility(this);
    }
}

