/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Arrays;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SplashPortalCondition
implements Condition {
    private static final List<SubType> checkedSubTypes = Arrays.asList(SubType.BIRD, SubType.FROG, SubType.OTTER, SubType.RAT);

    SplashPortalCondition() {
    }

    public boolean apply(Game game, Ability source) {
        if (source.getTargets().isEmpty()) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        return checkedSubTypes.stream().anyMatch(subType -> permanent.hasSubtype(subType, game));
    }

    public String toString() {
        return "If that creature is a Bird, Frog, Otter, or Rat";
    }
}

