/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageAllEffect;
import mage.abilities.effects.common.DamageControllerEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class SplinteringWindDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final UUID tokenId;

    SplinteringWindDelayedTriggeredAbility(UUID tokenId) {
        super((Effect)new DamageControllerEffect(1), Duration.OneUse);
        this.addEffect((Effect)new DamageAllEffect(1, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE));
        this.tokenId = tokenId;
    }

    private SplinteringWindDelayedTriggeredAbility(SplinteringWindDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.tokenId = ability.tokenId;
    }

    public SplinteringWindDelayedTriggeredAbility copy() {
        return new SplinteringWindDelayedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        return event.getTargetId().equals(this.tokenId) && (zEvent = (ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD;
    }

    public String getRule() {
        return "When it leaves the battlefield, it deals 1 damage to you and each creature you control.";
    }
}

