/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CreaturesDiedThisTurnCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.HorrorXXBlackToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class SpoilsOfBloodEffect
extends OneShotEffect {
    SpoilsOfBloodEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Create an X/X black Horror creature token, where X is the number of creatures that died this turn";
    }

    private SpoilsOfBloodEffect(SpoilsOfBloodEffect ability) {
        super((OneShotEffect)ability);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            new CreateTokenEffect((Token)new HorrorXXBlackToken(CreaturesDiedThisTurnCount.instance.calculate(game, source, (Effect)this))).apply(game, source);
            return true;
        }
        return false;
    }

    public SpoilsOfBloodEffect copy() {
        return new SpoilsOfBloodEffect(this);
    }
}

