/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SproutbackTrudgeEffect
extends OneShotEffect {
    SproutbackTrudgeEffect() {
        super(Outcome.Benefit);
        this.staticText = "cast {this} from your graveyard";
    }

    private SproutbackTrudgeEffect(SproutbackTrudgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SproutbackTrudgeEffect copy() {
        return new SproutbackTrudgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = source.getSourceCardIfItStillExists(game);
        if (player == null || card == null) {
            return false;
        }
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
        player.cast(player.chooseAbilityForCast(card, game, false), game, false, new ApprovingObject(source, game));
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
        return true;
    }
}

