/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.AnyColorLandsProduceManaAbility;
import mage.abilities.mana.ManaOptions;
import mage.choices.Choice;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SquanderedResourcesEffect
extends ManaEffect {
    SquanderedResourcesEffect() {
        this.staticText = "Add one mana of any type the sacrificed land could produce";
    }

    private SquanderedResourcesEffect(SquanderedResourcesEffect effect) {
        super((ManaEffect)effect);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        if (game != null && game.inCheckPlayableState()) {
            ManaOptions allPossibleMana = new ManaOptions();
            for (Permanent land : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_LAND, source.getControllerId(), game)) {
                ManaOptions currentPossibleMana = new ManaOptions();
                Set manaTypes = AnyColorLandsProduceManaAbility.getManaTypesFromPermanent((Permanent)land, (Game)game);
                if (manaTypes.size() == 5 && !manaTypes.contains(ManaType.COLORLESS) || manaTypes.size() == 6) {
                    currentPossibleMana.add((Object)Mana.AnyMana((int)1));
                    if (manaTypes.contains(ManaType.COLORLESS)) {
                        currentPossibleMana.add((Object)new Mana(ManaType.COLORLESS));
                    }
                } else {
                    for (ManaType manaType : manaTypes) {
                        currentPossibleMana.add((Object)new Mana(manaType));
                    }
                }
                allPossibleMana.addMana(currentPossibleMana);
            }
            allPossibleMana.removeFullyIncludedVariations();
            return new ArrayList<Mana>((Collection<Mana>)allPossibleMana);
        }
        return ManaType.getManaListFromManaTypes(this.getManaTypesFromSacrificedPermanent(game, source), (boolean)false);
    }

    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Choice choice = ManaType.getChoiceOfManaTypes(this.getManaTypesFromSacrificedPermanent(game, source), (boolean)false);
        if (!choice.getChoices().isEmpty()) {
            Player player = game.getPlayer(source.getControllerId());
            if (player == null) {
                return mana;
            }
            if (choice.getChoices().size() == 1) {
                choice.setChoice((String)choice.getChoices().iterator().next());
            } else if (!player.choose(Outcome.PutManaInPool, choice, game)) {
                return mana;
            }
            switch (choice.getChoice()) {
                case "Black": {
                    mana.setBlack(1);
                    break;
                }
                case "Blue": {
                    mana.setBlue(1);
                    break;
                }
                case "Red": {
                    mana.setRed(1);
                    break;
                }
                case "Green": {
                    mana.setGreen(1);
                    break;
                }
                case "White": {
                    mana.setWhite(1);
                    break;
                }
                case "Colorless": {
                    mana.setColorless(1);
                }
            }
        }
        return mana;
    }

    private Set<ManaType> getManaTypesFromSacrificedPermanent(Game game, Ability source) {
        HashSet<ManaType> types = new HashSet<ManaType>();
        for (Cost cost : source.getCosts()) {
            Permanent land;
            if (!(cost instanceof SacrificeTargetCost) || ((SacrificeTargetCost)cost).getPermanents().isEmpty() || (land = (Permanent)((SacrificeTargetCost)cost).getPermanents().get(0)) == null) continue;
            types.addAll(AnyColorLandsProduceManaAbility.getManaTypesFromPermanent((Permanent)land, (Game)game));
            break;
        }
        return types;
    }

    public SquanderedResourcesEffect copy() {
        return new SquanderedResourcesEffect(this);
    }
}

